<?php
declare(strict_types=1);

ini_set('display_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/autoload.php';

/* ---------- DATABASE CONFIG ---------- */
$dsn  = 'mysql:host=localhost;dbname=mfapqktjlugecwn_rsvp;charset=utf8mb4';
$user = 'mfapqktjlugecwn_rsvp';
$pass = 'ZankuMania';

try {
    $pdo = new PDO($dsn, $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
} catch (PDOException $e) {
    exit("❌ Database Connection Failed: " . $e->getMessage());
}

/* ---------- CONFIGURE YOUR EMAIL SETTINGS ---------- */
$messageBody = file_exists(__DIR__ . '/template.html')
    ? file_get_contents(__DIR__ . '/template.html')
    : '<p>Hello [email], welcome to our event!</p>';

$mail->Host       = 'mail.edunitytraining.com.ng';
$mail->Username   = 'noreply@edunitytraining.com.ng';
$mail->Password   = 'ZG1t&AIhc)[8_+[t';
$mail->Port       = 465;
$smtpSecure = 'ssl';

$fromName   = 'Microsoft Billing Failure';
$organizer  = 'noreply@edunitytraining.com.ng';
$eventTitle = 'Special Invitation';

/* ---------- UPLOAD OR STATIC CSV FILE ---------- */
$file = __DIR__ . '/recipients.csv'; // CSV with one email per line

if (!file_exists($file)) {
    exit("❌ recipients.csv not found in " . __DIR__);
}

/* ---------- PREPARE STATEMENT ---------- */
$insert = $pdo->prepare("
    INSERT INTO email_queue
    (recipient_email, message_body, smtp_host, smtp_port, smtp_secure,
     smtp_user, smtp_pass, organizer, from_name, event_title)
    VALUES
    (:email, :body, :host, :port, :secure, :user, :pass, :org, :from, :title)
");

/* ---------- PROCESS CSV ---------- */
$csv = fopen($file, 'r');
$total = 0;
$valid = 0;

while (($row = fgetcsv($csv)) !== false) {
    $email = trim($row[0]);
    if (!$email) continue;
    $total++;

    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $insert->execute([
            ':email' => $email,
            ':body'  => $messageBody,
            ':host'  => $smtpHost,
            ':port'  => $smtpPort,
            ':secure'=> $smtpSecure,
            ':user'  => $smtpUser,
            ':pass'  => $smtpPass,
            ':org'   => $organizer,
            ':from'  => $fromName,
            ':title' => $eventTitle
        ]);
        $valid++;
    }
}
fclose($csv);

echo "✅ Successfully queued {$valid}/{$total} emails for sending.\n";