<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>📧 RSVP Mailer</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <style>
    body {
        font-family: "Segoe UI", Roboto, sans-serif;
        background: linear-gradient(135deg, #2563eb, #9333ea);
        margin: 0;
        padding: 40px;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        min-height: 100vh;
        color: #1e293b;
    }

    .container {
        max-width: 900px;
        width: 100%;
        background: #fff;
        border-radius: 16px;
        padding: 32px;
        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.15);
        animation: fadeIn 0.6s ease;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        margin-top: 0;
        font-size: 28px;
        text-align: center;
        background: linear-gradient(90deg, #2563eb, #9333ea);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    h3 {
        margin-top: 30px;
        color: #2563eb;
        border-left: 4px solid #9333ea;
        padding-left: 8px;
    }

    label {
        font-weight: 600;
        display: block;
        margin: 14px 0 6px;
        font-size: 14px;
        color: #475569;
    }

    input,
    textarea,
    select {
        width: 100%;
        padding: 12px;
        border: 1px solid #d1d5db;
        border-radius: 10px;
        font-size: 14px;
        transition: 0.2s;
    }

    input:focus,
    textarea:focus,
    select:focus {
        border-color: #2563eb;
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.2);
        outline: none;
    }

    textarea {
        min-height: 120px;
        resize: vertical;
    }

    button {
        margin-top: 24px;
        padding: 14px;
        background: linear-gradient(135deg, #2563eb, #9333ea);
        color: #fff;
        border: none;
        border-radius: 10px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        width: 100%;
        transition: 0.25s;
        box-shadow: 0 6px 18px rgba(37, 99, 235, 0.25);
    }

    button:hover {
        transform: translateY(-2px);
        filter: brightness(1.1);
    }

    .file-preview {
        margin-top: 10px;
        font-size: 13px;
        color: #334155;
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        padding: 10px;
    }

    .file-preview ul {
        margin: 0;
        padding: 0 0 0 16px;
    }

    .footer {
        text-align: center;
        margin-top: 30px;
        font-size: 13px;
        color: #64748b;
    }

    .footer a {
        color: #2563eb;
        text-decoration: none;
        font-weight: 600;
    }
    </style>
</head>

<body>
    <div class="container">
        <h1>📧 RSVP Mailer</h1>
        <form action="bulk_rsvp_mailer.php" method="post" enctype="multipart/form-data">
            <h3>SMTP Settings</h3>
            <label>SMTP Host</label>
            <input type="text" name="smtp_host" placeholder="mail.example.com" required>

            <label>SMTP Port</label>
            <input type="number" name="smtp_port" value="465">

            <label>Encryption</label>
            <select name="smtp_secure">
                <option value="ssl">SSL</option>
                <option value="tls">TLS</option>
            </select>

            <label>SMTP Username</label>
            <input type="email" name="smtp_user" required>

            <label>SMTP Password</label>
            <input type="password" name="smtp_pass" required>

            <h3>Event Details</h3>
            <label>Organizer Email</label>
            <input type="email" name="organizer" required>

            <label>From Name</label>
            <input type="text" name="from_name" value="Event Manager">

            <label>Event Title</label>
            <input type="text" name="event_title" placeholder="Exclusive Tech Conference 2025" required>

            <label>Event Description</label>
            <textarea name="event_desc" placeholder="Enter a short description..."></textarea>

            <label>Event Location</label>
            <input type="text" name="event_loc" placeholder="Microsoft Teams / Abuja, Nigeria">

            <label>Event Start</label>
            <input type="datetime-local" name="event_start">

            <label>Event End</label>
            <input type="datetime-local" name="event_end">

            <label>Message Body (HTML allowed, use [base64email] where needed)</label>
            <textarea name="message_body" placeholder="Dear Guest, You are warmly invited..."></textarea>

            <h3>Upload Files</h3>
            <label>Recipients CSV</label>
            <input type="file" name="recipients" accept=".csv">

            <label>Attachments (any file type)</label>
            <input type="file" name="attachments[]" multiple accept="*/*" onchange="previewFiles(this)">
            <div class="file-preview" id="filePreview" style="display:none;">
                <strong>Selected Files:</strong>
                <ul id="fileList"></ul>
            </div>

            <button type="submit">🚀 Send Invitations</button>
        </form>

        <div class="footer">
            © 2025 RSVP Mailer | Developed by <a href="https://vincentagber.vercel.app/" target="_blank">Vincent
                Agber</a>
        </div>
    </div>

    <script>
    function previewFiles(input) {
        const preview = document.getElementById("filePreview");
        const list = document.getElementById("fileList");
        list.innerHTML = "";
        if (input.files.length > 0) {
            preview.style.display = "block";
            Array.from(input.files).forEach(file => {
                const li = document.createElement("li");
                li.textContent = `${file.name} (${(file.size/1024).toFixed(1)} KB)`;
                list.appendChild(li);
            });
        } else {
            preview.style.display = "none";
        }
    }
    </script>
</body>

</html>