<?php
declare(strict_types=1);
require __DIR__ . '/vendor/autoload.php';

ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/error_log.txt');
error_reporting(E_ALL);
ini_set('display_errors', '0');

// ---------- DB CONFIG ----------
$dsn  = 'mysql:host=localhost;dbname=mfapqktjlugecwn_rsvp;charset=utf8mb4';
$user = 'mfapqktjlugecwn_rsvp';
$pass = 'ZankuMania';

// ---------- Form Inputs ----------
$smtpHost    = $_POST['smtp_host'] ?? '';
$smtpPort    = (int)($_POST['smtp_port'] ?? 465);
$smtpSecure  = $_POST['smtp_secure'] ?? 'ssl';
$smtpUser    = $_POST['smtp_user'] ?? '';
$smtpPass    = $_POST['smtp_pass'] ?? '';
$organizer   = $_POST['organizer'] ?? '';
$fromName    = $_POST['from_name'] ?? 'Event Manager';
$eventTitle  = $_POST['event_title'] ?? 'Untitled Event';
$eventDesc   = $_POST['event_desc'] ?? '';
$eventLoc    = $_POST['event_loc'] ?? '';
$eventStart  = $_POST['event_start'] ?? '';
$eventEnd    = $_POST['event_end'] ?? '';
$messageBody = $_POST['message_body'] ?? '';

// ---------- Collect Recipients ----------
$csvFile = (isset($_FILES['recipients']) && $_FILES['recipients']['error'] === UPLOAD_ERR_OK)
    ? $_FILES['recipients']['tmp_name']
    : __DIR__ . '/recipients.csv';

$recipients = [];
if (($h = fopen($csvFile, 'r')) !== false) {
    while (($row = fgetcsv($h, 1000, ',')) !== false) {
        $email = trim($row[0]);
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $recipients[] = $email;
        }
    }
    fclose($h);
}
if (!$recipients) {
    exit('❌ No valid recipients found.');
}

// ---------- Handle Attachments ----------
$attachments = [];
if (!empty($_FILES['attachments']['name'][0])) {
    foreach ($_FILES['attachments']['tmp_name'] as $k => $tmp) {
        if ($_FILES['attachments']['error'][$k] === UPLOAD_ERR_OK) {
            $unique = uniqid('att_', true);
            $dest   = __DIR__ . "/uploads/{$unique}_" . basename($_FILES['attachments']['name'][$k]);
            if (!is_dir(__DIR__ . '/uploads')) mkdir(__DIR__ . '/uploads', 0775, true);
            if (move_uploaded_file($tmp, $dest)) {
                $attachments[] = $dest;
            }
        }
    }
}

// ---------- Insert Queue ----------
try {
    $pdo = new PDO($dsn, $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);

    $stmt = $pdo->prepare("
        INSERT INTO email_queue 
        (recipient_email, message_body, attachments, smtp_host, smtp_port, smtp_secure,
         smtp_user, smtp_pass, organizer, from_name, event_title, event_desc,
         event_loc, event_start, event_end)
        VALUES
        (:email, :body, :attachments, :host, :port, :secure,
         :user, :pass, :organizer, :from_name, :event_title, :event_desc,
         :event_loc, :event_start, :event_end)
    ");

    $attJson = $attachments ? json_encode($attachments) : null;

    foreach ($recipients as $email) {
        $stmt->execute([
            ':email'      => $email,
            ':body'       => $messageBody,
            ':attachments'=> $attJson,
            ':host'       => $smtpHost,
            ':port'       => $smtpPort,
            ':secure'     => $smtpSecure,
            ':user'       => $smtpUser,
            ':pass'       => $smtpPass,
            ':organizer'  => $organizer,
            ':from_name'  => $fromName,
            ':event_title'=> $eventTitle,
            ':event_desc' => $eventDesc,
            ':event_loc'  => $eventLoc,
            ':event_start'=> $eventStart ?: null,
            ':event_end'  => $eventEnd ?: null
        ]);
    }

    echo "✅ Successfully queued " . count($recipients) . " emails.";
} catch (PDOException $e) {
    error_log($e->getMessage());
    exit("Database Error: " . htmlspecialchars($e->getMessage()));
}